<?php
declare(strict_types=1);
require_once __DIR__ . '/config.php';

function db(): PDO {
    static $pdo;
    if (!$pdo) {
        $dsn = sprintf("mysql:host=%s;dbname=%s;charset=utf8mb4", DB_HOST, DB_NAME);
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        try {
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
            
            // رفع مشکل نمایش نوبت‌ها: هماهنگ‌سازی ساعت MySQL با تهران
            $pdo->exec("SET NAMES utf8mb4");
            $pdo->exec("SET time_zone = '+03:30'"); 
        } catch (PDOException $e) {
            // در محیط واقعی جزئیات خطا را لاگ کنید نه نمایش
            error_log($e->getMessage());
            die('خطا در اتصال به دیتابیس. لطفا تنظیمات config.php را بررسی کنید.');
        }
    }
    return $pdo;
}