// Theme Manager
const themeToggle = document.getElementById('theme-toggle');
const root = document.documentElement;
const prefersDarkScheme = window.matchMedia('(prefers-color-scheme: dark)');

function setTheme(theme) {
    if (theme === 'dark') {
        root.setAttribute('data-theme', 'dark');
        localStorage.setItem('theme', 'dark');
    } else if (theme === 'light') {
        root.setAttribute('data-theme', 'light');
        localStorage.setItem('theme', 'light');
    } else {
        root.removeAttribute('data-theme');
        localStorage.removeItem('theme');
    }
}

// Initial Theme Check
const currentTheme = localStorage.getItem('theme');
if (currentTheme) {
    setTheme(currentTheme);
}

if(themeToggle) {
    themeToggle.addEventListener('click', () => {
        let theme = root.getAttribute('data-theme');
        if (!theme) {
            theme = prefersDarkScheme.matches ? 'light' : 'dark';
        } else {
            theme = theme === 'dark' ? 'light' : 'dark';
        }
        setTheme(theme);
    });
}

document.addEventListener('DOMContentLoaded', () => {
    
    // Tabs Management
    const tabs = document.querySelectorAll('.nav-item');
    const contents = document.querySelectorAll('.tab-content');

    function switchTab(targetId) {
        tabs.forEach(t => t.classList.toggle('active', t.dataset.target === targetId));
        contents.forEach(c => c.classList.toggle('active', c.id === targetId));
        const hash = targetId === 'lookup-tab' ? '#lookup' : '#';
        if(history.replaceState) history.replaceState(null, null, hash);
    }

    tabs.forEach(tab => tab.addEventListener('click', () => switchTab(tab.dataset.target)));
    if (window.location.hash === '#lookup') switchTab('lookup-tab');

    // Smooth Scroll for active date
    const activeDate = document.querySelector('.date-pill.active');
    if (activeDate) activeDate.scrollIntoView({ behavior: 'smooth', inline: 'center', block: 'nearest' });

    // Copy Tracking Code
    const notification = document.querySelector('.notification');
    if (notification && notification.innerText.includes('کد رهگیری')) {
        const text = notification.innerText;
        const codeMatch = text.match(/:\s*([A-Za-z0-9\-]+)/);
        if (codeMatch && codeMatch[1]) {
            const code = codeMatch[1].trim();
            const copyBtn = document.createElement('span');
            copyBtn.innerHTML = ' <strong style="cursor:pointer;text-decoration:underline;margin-right:5px">(کپی)</strong>';
            copyBtn.onclick = () => {
                navigator.clipboard.writeText(code);
                alert('کد رهگیری کپی شد: ' + code);
            };
            notification.appendChild(copyBtn);
        }
    }

    // AJAX Selection for Service and Date
    let currentService = document.getElementById('form_service_id')?.value;
    let currentDate = document.getElementById('form_ymd')?.value;

    async function fetchSlots() {
        if(!currentService || !currentDate) return;
        
        try {
            const response = await fetch(`index.php?action=get_slots&service_id=${currentService}&ymd=${currentDate}`);
            const data = await response.json();
            
            const timeGrid = document.getElementById('time-grid-container');
            const form = document.getElementById('booking-form');
            const emptyMsg = document.getElementById('empty-slots-msg');
            
            if (data.slots && data.slots.length > 0) {
                timeGrid.innerHTML = data.slots.map(t => `
                    <label class="time-radio">
                        <input type="radio" name="time" value="${t}" required>
                        <span class="time-badge">${t}</span>
                    </label>
                `).join('');
                form.style.display = 'block';
                emptyMsg.style.display = 'none';
            } else {
                form.style.display = 'none';
                emptyMsg.style.display = 'block';
            }
        } catch (error) {
            console.error("Error fetching slots", error);
        }
    }

    document.querySelectorAll('.service-card').forEach(card => {
        card.addEventListener('click', (e) => {
            e.preventDefault();
            document.querySelectorAll('.service-card').forEach(c => {
                c.classList.remove('active');
                c.querySelector('.check-icon').style.display = 'none';
            });
            card.classList.add('active');
            card.querySelector('.check-icon').style.display = 'block';
            
            currentService = card.dataset.id;
            document.getElementById('form_service_id').value = currentService;
            fetchSlots();
        });
    });

    document.querySelectorAll('.date-pill').forEach(pill => {
        pill.addEventListener('click', (e) => {
            e.preventDefault();
            document.querySelectorAll('.date-pill').forEach(p => p.classList.remove('active'));
            pill.classList.add('active');
            
            currentDate = pill.dataset.ymd;
            document.getElementById('form_ymd').value = currentDate;
            fetchSlots();
        });
    });
});