<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../utils.php';

if (session_status() !== PHP_SESSION_ACTIVE) session_start();
$pdo = db();

$msg = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $u = trim((string)($_POST['username'] ?? ''));
  $p = (string)($_POST['password'] ?? '');

  $st = $pdo->prepare("SELECT id, password_hash FROM admins WHERE username=? LIMIT 1");
  $st->execute([$u]);
  $row = $st->fetch();

  if ($row && password_verify($p, $row['password_hash'])) {
    $_SESSION['admin_id'] = (int)$row['id'];
    header('Location: index.php');
    exit;
  }
  $msg = 'نام کاربری یا رمز اشتباه است.';
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1, viewport-fit=cover, maximum-scale=1, user-scalable=no">
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/booking-modern.css?v=3">
  <script src="../assets/booking-modern.js?v=3" defer></script>
  <title>ورود ادمین | رزرو</title>
</head>
<body class="app-shell" style="display:flex; align-items:center; justify-content:center;">

<div class="app-container" style="width:100%;">
  <div class="admin-card" style="text-align:center;">
    <div style="font-size:3rem; color:var(--primary); margin-bottom:10px;"><i class="ri-shield-user-fill"></i></div>
    <h1 style="margin-bottom: 24px;">ورود مدیریت</h1>
    
    <?php if ($msg): ?>
        <div class="notification animate-pop" style="background:var(--danger-bg); color:var(--danger); border-color:var(--danger);">
            <i class="ri-error-warning-line"></i> <?= e($msg) ?>
        </div>
    <?php endif; ?>

    <form method="post" style="text-align:right;">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <div class="input-group">
          <label>نام کاربری</label>
          <input class="input-select" name="username" required>
      </div>
      <div class="input-group">
          <label>رمز عبور</label>
          <input class="input-select" type="password" name="password" required>
      </div>
      <div style="margin-top:24px">
        <button class="btn-primary" type="submit">
            <span>ورود به پنل</span>
            <i class="ri-login-circle-line"></i>
        </button>
      </div>
    </form>
    
    <div style="margin-top: 20px;">
        <button class="theme-toggle" id="theme-toggle" style="margin: 0 auto;">
            <i class="ri-moon-fill dark-icon"></i>
            <i class="ri-sun-fill light-icon"></i>
        </button>
    </div>
  </div>
</div>

</body>
</html>