<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../config.php';

if (session_status() !== PHP_SESSION_ACTIVE) session_start();
if (empty($_SESSION['admin_id'])) { header('Location: login.php'); exit; }

$pdo = db();
$msg = $_SESSION['msg'] ?? null;
unset($_SESSION['msg']);

$operators = $pdo->query("SELECT * FROM operators WHERE is_active=1 ORDER BY id")->fetchAll();
$services = $pdo->query("SELECT s.*, o.name as operator_name FROM services s LEFT JOIN operators o ON s.operator_id=o.id WHERE s.is_active=1 ORDER BY s.id")->fetchAll();
$mode = $_POST['mode'] ?? '';

// --- آمار داشبورد ---
$stats = [
    'total_today' => 0,
    'total_upcoming' => 0,
    'chart_labels' => [],
    'chart_data' => []
];

$st = $pdo->prepare("SELECT COUNT(*) FROM appointments WHERE DATE(start_at) = CURDATE() AND status='CONFIRMED'");
$st->execute();
$stats['total_today'] = $st->fetchColumn();

$st = $pdo->prepare("SELECT COUNT(*) FROM appointments WHERE start_at > NOW() AND status='CONFIRMED'");
$st->execute();
$stats['total_upcoming'] = $st->fetchColumn();

$st = $pdo->query("SELECT DATE(start_at) as d, COUNT(*) as c 
                   FROM appointments 
                   WHERE start_at >= DATE_SUB(CURDATE(), INTERVAL 6 DAY)
                   GROUP BY DATE(start_at) 
                   ORDER BY d ASC");
$rows = $st->fetchAll(PDO::FETCH_KEY_PAIR);

for ($i=6; $i>=0; $i--) {
    $d = date('Y-m-d', strtotime("-$i days"));
    $stats['chart_labels'][] = get_persian_date_label($d); 
    $stats['chart_data'][] = $rows[$d] ?? 0;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_check();

    // 1. تنظیمات زمانی
    if ($mode === 'set_hours') {
        $op = (int)($_POST['operator_id'] ?? 0);
        $weekday = (int)($_POST['weekday'] ?? 0);
        $start = (string)($_POST['start_time'] ?? '');
        $end = (string)($_POST['end_time'] ?? '');
        $allWeek = isset($_POST['all_week']);

        if ($op && $start && $end) {
            if ($allWeek) {
                $days = [6,0,1,2,3,4];
                foreach ($days as $day) {
                    $pdo->prepare("DELETE FROM working_hours WHERE operator_id=? AND weekday=?")->execute([$op, $day]);
                    $pdo->prepare("INSERT INTO working_hours(operator_id,weekday,start_time,end_time) VALUES(?,?,?,?)")->execute([$op, $day, $start, $end]);
                }
            } else {
                $pdo->prepare("DELETE FROM working_hours WHERE operator_id=? AND weekday=?")->execute([$op, $weekday]);
                $pdo->prepare("INSERT INTO working_hours(operator_id,weekday,start_time,end_time) VALUES(?,?,?,?)")->execute([$op, $weekday, $start, $end]);
            }
            $_SESSION['msg'] = 'ساعت کاری با موفقیت ذخیره شد.';
        }
    } 
    // 2. لغو نوبت توسط ادمین
    elseif ($mode === 'cancel_appt') {
        $appt_id = (int)($_POST['appointment_id'] ?? 0);
        if ($appt_id) {
            $pdo->prepare("UPDATE appointments SET status='CANCELED' WHERE id=?")->execute([$appt_id]);
            $_SESSION['msg'] = 'نوبت با موفقیت لغو شد.';
        }
    }
    // 3. ثبت نوبت دستی توسط ادمین
    elseif ($mode === 'add_appt') {
        $sid = (int)$_POST['service_id'];
        $ymd = $_POST['date'];
        $time = $_POST['time'];
        $name = $_POST['full_name'];
        $phone = normalize_phone($_POST['phone']);

        $svSt = $pdo->prepare("SELECT duration_minutes, operator_id FROM services WHERE id=?");
        $svSt->execute([$sid]);
        $sv = $svSt->fetch();

        if ($sv && $ymd && $time) {
            $start = new DateTime("$ymd $time:00", new DateTimeZone('Asia/Tehran'));
            $end = (clone $start)->modify('+' . $sv['duration_minutes'] . ' minutes');

            if (is_taken($pdo, (int)$sv['operator_id'], $start, $end)) {
                $_SESSION['msg'] = 'خطا: این زمان قبلاً برای این اپراتور رزرو شده یا تداخل دارد.';
            } else {
                // ثبت مشتری و نوبت
                $st = $pdo->prepare("SELECT id FROM customers WHERE phone=? LIMIT 1");
                $st->execute([$phone]);
                $cid = $st->fetchColumn();
                if (!$cid) {
                    $pdo->prepare("INSERT INTO customers(full_name, phone) VALUES(?, ?)")->execute([$name, $phone]);
                    $cid = $pdo->lastInsertId();
                }
                $code = tracking_code(10);
                $pdo->prepare("INSERT INTO appointments(customer_id, service_id, operator_id, start_at, end_at, tracking_code, status) VALUES(?,?,?,?,?,?, 'CONFIRMED')")
                    ->execute([$cid, $sid, $sv['operator_id'], $start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s'), $code]);
                $_SESSION['msg'] = 'نوبت با موفقیت ثبت شد.';
            }
        }
    }
    // 4. مدیریت اپراتورها (افزودن و حذف)
    elseif ($mode === 'add_operator') {
        $name = trim($_POST['operator_name'] ?? '');
        if ($name) {
            $pdo->prepare("INSERT INTO operators (name, is_active) VALUES (?, 1)")->execute([$name]);
            $_SESSION['msg'] = 'اپراتور با موفقیت اضافه شد.';
        }
    }
    elseif ($mode === 'delete_operator') {
        $op_id = (int)$_POST['operator_id'];
        $pdo->prepare("UPDATE operators SET is_active=0 WHERE id=?")->execute([$op_id]);
        $_SESSION['msg'] = 'اپراتور با موفقیت حذف شد.';
    }
    // 5. مدیریت خدمات (افزودن، ویرایش، جابجایی اپراتور، تنظیم زمان و حذف)
    elseif ($mode === 'add_service') {
        $title = trim($_POST['title'] ?? '');
        $dur = (int)$_POST['duration_minutes'];
        $op_id = (int)$_POST['operator_id'];
        if ($title && $dur && $op_id) {
            $pdo->prepare("INSERT INTO services (title, duration_minutes, operator_id, is_active) VALUES (?, ?, ?, 1)")->execute([$title, $dur, $op_id]);
            $_SESSION['msg'] = 'خدمت جدید اضافه شد.';
        }
    }
    elseif ($mode === 'edit_service') {
        $sid = (int)$_POST['service_id'];
        if (isset($_POST['delete_service'])) {
            $pdo->prepare("UPDATE services SET is_active=0 WHERE id=?")->execute([$sid]);
            $_SESSION['msg'] = 'خدمت با موفقیت حذف شد.';
        } else {
            $title = trim($_POST['title']);
            $dur = (int)$_POST['duration'];
            $op_id = (int)$_POST['operator_id'];
            $pdo->prepare("UPDATE services SET title=?, duration_minutes=?, operator_id=? WHERE id=?")->execute([$title, $dur, $op_id, $sid]);
            $_SESSION['msg'] = 'تنظیمات خدمت با موفقیت به‌روز شد.';
        }
    }
    
    header('Location: index.php');
    exit;
}

$st = $pdo->prepare("SELECT a.id, a.start_at, a.status, s.title, o.name AS operator_name, c.full_name, c.phone 
                     FROM appointments a
                     LEFT JOIN services s ON a.service_id = s.id
                     LEFT JOIN operators o ON a.operator_id = o.id
                     LEFT JOIN customers c ON a.customer_id = c.id
                     WHERE (DATE(a.start_at) >= CURDATE()) OR (a.status = 'CONFIRMED' AND a.start_at > NOW())
                     ORDER BY a.start_at ASC");
$st->execute();
$appts = $st->fetchAll();
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1, viewport-fit=cover, maximum-scale=1, user-scalable=no">
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/booking-modern.css?v=7">
  <script src="../assets/booking-modern.js?v=7" defer></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <title>پنل مدیریت | <?= e(APP_NAME) ?></title>
</head>
<body class="app-shell">

<div class="app-container admin-container">
  <header class="app-header">
    <div class="brand">
        <h1>پنل مدیریت</h1>
        <p>داشبورد سیستم نوبت‌دهی</p>
    </div>
    <div style="display:flex; gap: 10px;">
        <button class="theme-toggle" id="theme-toggle" aria-label="تغییر تم">
            <i class="ri-moon-fill dark-icon"></i>
            <i class="ri-sun-fill light-icon"></i>
        </button>
        <a href="logout.php" class="theme-toggle" style="color:var(--danger)"><i class="ri-logout-box-r-line"></i></a>
    </div>
  </header>

  <?php if ($msg): ?>
    <div class="notification animate-pop">
      <i class="ri-check-double-line"></i> <?= e($msg) ?>
    </div>
  <?php endif; ?>

  <nav class="nav-tabs">
    <button type="button" class="nav-item active" data-target="tab-dash">داشبورد</button>
    <button type="button" class="nav-item" data-target="tab-appts">نوبت‌ها</button>
    <button type="button" class="nav-item" data-target="tab-settings">تنظیمات</button>
  </nav>

  <main id="tab-dash" class="tab-content active">
      <div class="dashboard-stats" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
          <div class="admin-card" style="margin:0; text-align:center;">
              <h3 style="margin:0; font-size: 0.9rem; color:var(--text-muted)">نوبت‌های امروز</h3>
              <span style="font-size: 2rem; font-weight:900; color:var(--primary)"><?= $stats['total_today'] ?></span>
          </div>
          <div class="admin-card" style="margin:0; text-align:center;">
              <h3 style="margin:0; font-size: 0.9rem; color:var(--text-muted)">نوبت‌های آینده</h3>
              <span style="font-size: 2rem; font-weight:900; color: #10b981"><?= $stats['total_upcoming'] ?></span>
          </div>
      </div>

      <div class="admin-card">
          <h2 class="section-title"><i class="ri-bar-chart-line"></i> آمار ۷ روز گذشته</h2>
          <canvas id="appointmentsChart" height="150"></canvas>
      </div>
      
      <div class="admin-card">
        <h2 class="section-title"><i class="ri-time-line"></i> تنظیم ساعت کاری اپراتور</h2>
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="mode" value="set_hours">
          <div class="input-group">
            <label>انتخاب اپراتور</label>
            <select class="input-select" name="operator_id" required>
              <?php foreach($operators as $o): ?>
                <option value="<?= (int)$o['id'] ?>"><?= e($o['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="input-group">
            <label>روز هفته (0=یکشنبه تا 6=شنبه)</label>
            <input class="input-select" name="weekday" type="number" min="0" max="6" value="6">
            <label style="display:flex; align-items:center; gap:8px; margin-top:8px; cursor:pointer;">
              <input type="checkbox" name="all_week" value="1"> اعمال یکپارچه برای شنبه تا پنجشنبه
            </label>
          </div>
          <div style="display:flex; gap:10px;">
              <div class="input-group">
                <label>ساعت شروع</label>
                <input class="input-select" name="start_time" type="time" required>
              </div>
              <div class="input-group">
                <label>ساعت پایان</label>
                <input class="input-select" name="end_time" type="time" required>
              </div>
          </div>
          <button class="btn-primary" type="submit">ذخیره تنظیمات</button>
        </form>
      </div>
  </main>

  <main id="tab-appts" class="tab-content">
      <div class="admin-card">
          <h2 class="section-title"><i class="ri-add-circle-line"></i> ثبت نوبت جدید توسط مدیریت</h2>
          <form method="post" style="display:flex; flex-direction:column; gap:10px">
              <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="mode" value="add_appt">
              
              <div class="input-group">
                  <select class="input-select" name="service_id" required>
                      <option value="">انتخاب خدمت...</option>
                      <?php foreach($services as $s): ?>
                          <option value="<?= $s['id'] ?>"><?= e($s['title']) ?> (<?= e($s['operator_name']) ?>)</option>
                      <?php endforeach; ?>
                  </select>
              </div>
              
              <div style="display:flex; gap:10px;">
                  <div class="input-group">
                      <input class="input-select" type="date" name="date" required>
                  </div>
                  <div class="input-group">
                      <input class="input-select" type="time" name="time" required>
                  </div>
              </div>

              <div style="display:flex; gap:10px;">
                  <div class="input-group">
                      <input class="input-select" type="text" name="full_name" placeholder="نام مشتری" required>
                  </div>
                  <div class="input-group">
                      <input class="input-select" type="tel" name="phone" placeholder="موبایل مشتری" required>
                  </div>
              </div>
              <button class="btn-secondary" type="submit" style="background:var(--primary); color:white; border:none;">ثبت و رزرو نوبت</button>
          </form>
      </div>

      <h3 class="section-title"><i class="ri-list-check"></i> لیست نوبت‌های فعال</h3>
      <?php if (!$appts): ?>
        <div class="empty-state"><i class="ri-inbox-line"></i><p>هیچ نوبتی یافت نشد.</p></div>
      <?php else: ?>
        <div class="appointments-list">
          <?php foreach($appts as $a): ?>
            <div class="appt-card">
              <div class="appt-header">
                  <span style="color:var(--primary); font-size:1.1rem; direction:ltr; display:inline-block;">
                      <?= e(format_datetime_jalali($a['start_at'])) ?>
                  </span>
                  <span class="status-<?= strtolower($a['status']) ?>"><?= $a['status'] === 'CONFIRMED' ? 'تایید شده' : 'لغو شده' ?></span>
              </div>
              <div class="appt-details">
                  <div><i class="ri-user-smile-line"></i> <?= e($a['full_name'] ?? 'نامشخص') ?> (<?= e($a['phone'] ?? '---') ?>)</div>
                  <div><i class="ri-scissors-cut-line"></i> <?= e($a['title'] ?? '---') ?> • اپراتور: <?= e($a['operator_name'] ?? '---') ?></div>
              </div>
              <?php if ($a['status']==='CONFIRMED'): ?>
                <form method="post" style="margin-top:12px" onsubmit="return confirm('آیا از لغو این نوبت مطمئن هستید؟');">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="mode" value="cancel_appt">
                  <input type="hidden" name="appointment_id" value="<?= (int)$a['id'] ?>">
                  <button class="btn-danger btn-secondary" style="padding:10px" type="submit">لغو نوبت</button>
                </form>
              <?php endif; ?>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
  </main>

  <main id="tab-settings" class="tab-content">
      <div class="admin-card">
          <h2 class="section-title"><i class="ri-group-line"></i> مدیریت پرسنل و اپراتورها</h2>
          
          <form method="post" style="display:flex; gap:10px; margin-bottom: 20px;">
              <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="mode" value="add_operator">
              <input class="input-select" type="text" name="operator_name" placeholder="نام اپراتور جدید" required>
              <button class="btn-primary" type="submit" style="width:auto; padding:0 20px;">افزودن</button>
          </form>

          <div style="display:flex; flex-direction:column; gap:8px;">
              <?php foreach($operators as $o): ?>
                  <div style="display:flex; justify-content:space-between; align-items:center; background:var(--bg-page); padding:10px; border-radius:10px; border:1px solid var(--border)">
                      <span style="font-weight:bold"><?= e($o['name']) ?></span>
                      <form method="post" onsubmit="return confirm('حذف شود؟')">
                          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                          <input type="hidden" name="mode" value="delete_operator">
                          <input type="hidden" name="operator_id" value="<?= $o['id'] ?>">
                          <button type="submit" style="background:none; border:none; color:var(--danger); cursor:pointer"><i class="ri-delete-bin-line"></i> حذف</button>
                      </form>
                  </div>
              <?php endforeach; ?>
          </div>
      </div>

      <div class="admin-card" style="padding-bottom:10px">
          <h2 class="section-title"><i class="ri-service-line"></i> مدیریت خدمات (زمان و جابجایی)</h2>
          
          <form method="post" style="display:flex; flex-direction:column; gap:10px; margin-bottom:20px; padding-bottom:20px; border-bottom:1px dashed var(--border)">
              <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="mode" value="add_service">
              <div style="display:flex; gap:10px;">
                  <input class="input-select" type="text" name="title" placeholder="نام خدمت (مثلا ماساژ)" required style="flex:2">
                  <input class="input-select" type="number" name="duration_minutes" placeholder="دقیقه" required style="flex:1">
              </div>
              <div style="display:flex; gap:10px;">
                  <select class="input-select" name="operator_id" required>
                      <option value="">انتخاب اپراتور پیش‌فرض...</option>
                      <?php foreach($operators as $o): ?>
                          <option value="<?= $o['id'] ?>"><?= e($o['name']) ?></option>
                      <?php endforeach; ?>
                  </select>
                  <button class="btn-primary" type="submit" style="width:auto; padding:0 20px;">افزودن</button>
              </div>
          </form>

          <div style="font-size:0.85rem; color:var(--text-muted); margin-bottom:10px">ویرایش خدمات موجود:</div>
          <?php foreach($services as $s): ?>
              <form method="post" style="display:flex; flex-wrap:wrap; gap:5px; align-items:center; background:var(--bg-page); padding:10px; border-radius:10px; border:1px solid var(--border); margin-bottom:10px;">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="mode" value="edit_service">
                  <input type="hidden" name="service_id" value="<?= $s['id'] ?>">
                  
                  <input class="input-select" name="title" value="<?= e($s['title']) ?>" style="padding:8px; width:calc(50% - 5px)" title="نام خدمت">
                  <input class="input-select" type="number" name="duration" value="<?= $s['duration_minutes'] ?>" style="padding:8px; width:calc(50% - 5px)" title="زمان (دقیقه)">
                  
                  <select class="input-select" name="operator_id" style="padding:8px; width:calc(100% - 90px)" title="انتخاب اپراتور">
                      <?php foreach($operators as $o): ?>
                          <option value="<?= $o['id'] ?>" <?= $o['id']==$s['operator_id']?'selected':'' ?>><?= e($o['name']) ?></option>
                      <?php endforeach; ?>
                  </select>
                  
                  <button type="submit" style="background:var(--primary); color:white; border:none; border-radius:8px; padding:8px 10px; cursor:pointer"><i class="ri-save-line"></i></button>
                  <button type="submit" name="delete_service" value="1" style="background:var(--danger-bg); color:var(--danger); border:none; border-radius:8px; padding:8px 10px; cursor:pointer" onclick="return confirm('مطمئن هستید؟')"><i class="ri-delete-bin-line"></i></button>
              </form>
          <?php endforeach; ?>
      </div>
  </main>
</div>

<script>
const ctx = document.getElementById('appointmentsChart').getContext('2d');
const isDark = document.documentElement.getAttribute('data-theme') === 'dark' || (!localStorage.getItem('theme') && window.matchMedia('(prefers-color-scheme: dark)').matches);
const textColor = isDark ? '#94a3b8' : '#64748b';
const gridColor = isDark ? '#334155' : '#e2e8f0';

new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?= json_encode($stats['chart_labels']) ?>,
        datasets: [{
            label: 'تعداد نوبت',
            data: <?= json_encode($stats['chart_data']) ?>,
            borderColor: '#4f46e5', backgroundColor: 'rgba(79, 70, 229, 0.1)',
            borderWidth: 3, fill: true, tension: 0.4,
            pointBackgroundColor: '#fff', pointBorderColor: '#4f46e5', pointRadius: 4
        }]
    },
    options: {
        responsive: true,
        plugins: { legend: { display: false } },
        scales: {
            y: { beginAtZero: true, grid: { color: gridColor }, ticks: { color: textColor, stepSize: 1 } },
            x: { grid: { display: false }, ticks: { color: textColor, font: {family: 'IRANSans'} } }
        }
    }
});
</script>
</body>
</html>